var express = require('express');
var bodyparser=require('body-parser');
var jwt=require('./util/jwtHelper');

var run_port=9000;

var db = require('./database/db');

var app = express();
app.use(bodyparser.json());
app.use(bodyparser.urlencoded({ extended: true }));

////

app.use(function (req,res,next) {
    console.log(req.path);

    // url not require authorization
    if(
        req.path=='/api/user/login' ||
        req.path=='/api/server/status'
    )
    {
        next();
    }
    else
    {
        // url require authorization
        if(req.headers.authorization)
        {
            //  console.log("token "+req.headers.authorization);
            var tokenGet=req.headers.authorization.replace('Bearer ','');
            // console.log(tokenGet);
            var payload=jwt.verify(tokenGet);
            if(payload==null)
            {
                console.log("token not set ");
                res.status(401).end('Authorization Faild');
            }
            else
            {
                console.log("requset from user : "+payload.username);
                next();
            }
        }
        else
        {
            res.status(401).end('Authorization Not Set');
            console.log('Authorization NotSet')
        }
    }
});



/////

var routerUser=require('./Router/user');
var routerUpdate=require('./Router/update');

app.use('/api/user',routerUser);
app.use('/api/server', routerUpdate);
app.use('/', routerUpdate);

app.use(function (req,res) {
    res.status(404).send('Url Not Found');
});
var server = app.listen(run_port, function () {
    console.log('Server is running on port : '+run_port);
});

