/**
 * Created by Mojtaba on 2020-04-12.
 */
var express = require("express");
var crypto = require('crypto');
var router = express.Router();
var jwt = require('./../util/jwtHelper');
var db = require('./../database/db');
// var fs = require('fs');
// var jalaali = require('jalaali-js');
// var moment = require('moment-jalaali');
// var momentOrg= require('moment');
// var Sync = require('sync');


router.post("/login", function (req, res) {
    var username='';
    var password='';
    try {
        username=req.body.username.trim();
        password=req.body.password.trim();
    }
    catch(ein){
        username='';
        password='';
    }

    if (username != '' && password != '') {
       try {
            db.getUser("username",username, function (result) {
                if (result == -1 || result == -2) {
                   // console.log("error connect DB");
                    ret={
                        message:"User Not Found",
                        user_id:0,
                        name:'',
                        type:''
                    }
                    res.status(404).json(ret);

                } else {
                    var hashpassword = crypto.createHash('md5').update(password).digest("hex");
                    if (result.password == hashpassword) {
                        delete result.password;
                        // felan = be ja ==
                        if (result.status == 1) {
                            var tokenSet = "Bearer " + jwt.signUser(result.username, result.user_id, result.senderType, result.ostan, result.kgId, result.kgName,result.shahrestan);
                            result.token = tokenSet;

                            console.log(result.username +' -> Login Successful ');

                            res.status(200).json(result);
                        }
                        else {

                            ret={
                                message:"User Not Active",
                                user_id:result.user_id,
                                name:'',
                                type:''
                            };
                            console.log(result.username + ' -> User Not Active  ');
                            res.status(403).json(ret);
                        }
                    }
                    else {
                        console.log(result.username + ' ' + result.name + ' ' + result.lastname + ' -> Password Error ');

                         ret={
                            message:"Wrong Password",
                             user_id:result.user_id,
                             name:'',
                             type:''
                        };
                        res.status(401).json(ret);
                    }


                }
            });
       }
       catch (e) {
            res.status(400).send("Internal Error");
       }
    }
    else {
        res.status(400).send("Please Enter All Input");
    }
});

router.post("/me", function (req, res) {
    var tokenGet = req.headers.authorization.replace('Bearer ', '');
    // console.log(tokenGet);

    var payload = jwt.verify(tokenGet);
    if (payload.username) {
        db.getUser("id",payload.user_id, function (result) {
            if (result == -1 || result==-2) {
                res.status(501).send("error db");

            } else {

                delete result.password;
                console.log(result.username + " Get Me");
                res.status(200).json(result);

            }
        });
    }
});

router.post("/me/ChangePassword", function (req, res) {
    if (req.body.password.trim() != '' && req.body.new_password.trim() != '') {
        var tokenGet = req.headers.authorization.replace('Bearer ', '');
        var payload = jwt.verify(tokenGet);

        if (payload.username) {
            var oldpass = crypto.createHash('md5').update(req.body.password.trim()).digest('hex');
            var newpass = crypto.createHash('md5').update(req.body.new_password.trim()).digest('hex');

            db.changeMyPass(payload.user_id,oldpass,newpass, function (result) {
                if (result > 0) {
                    console.log('change password ');
                    res.status(200).send("password changed !");

                } else {
                    console.log('change password Error :' + payload.username );
                    res.status(501).send("error db");
                }
            });
        }
    }
    else {
        res.status(404).end("Please Enter All Input");
    }

});

router.get('/:id', function (req, res) {

    if(req.params.id!=null) {

        var tokenGet = req.headers.authorization.replace('Bearer ', '');
        // console.log(tokenGet);

        var payload = jwt.verify(tokenGet);
        if (payload.username) {
            db.getUser("id", payload.user_id, function (result) {
                if (result == -1) {
                    res.status(501).send("error db");

                }
                else if (result==-2) {
                    res.status(404).send("user not found");

                }else {

                    db.getUser("id",req.params.id, function (result_ret) {
                        if (result_ret == -1 || result_ret==-2) {
                            res.status(501).send("error db");

                        } else {
                            if ((result_ret.user_id==payload.user_id) || ((result.type == 'admin' || result.type == 'superuser') && result.status == 1 && result_ret.type != 'superuser')) {
                                delete result_ret.password;
                                console.log("View Username :  "+ result_ret.username);
                                res.status(200).json(result_ret);
                            }
                            else {
                                res.status(401).send("Permission Denied");
                            }
                        }
                    });

                }
            });
        }
    }
    else
    {
        res.status(400).send("user id require");
    }
});

router.get('/', function (req, res) {
    var tokenGet = req.headers.authorization.replace('Bearer ', '');
    // console.log(tokenGet);

    var payload = jwt.verify(tokenGet);
    if (payload.username) {
        db.getUser("id",payload.user_id, function (result) {
            if (result == -1 || result==-2) {
                res.status(501).send("error db");

            } else {
                if((result.type=='admin' || result.type=='superuser' ) && result.status==1)
                {
                    db.getUserList(result.type,function (result) {
                        if (result == -1) {
                            res.status(501).send("error db");

                        } else {

                            for(i in result) {
                                delete result[i].password;
                            }
                            res.status(200).json(result);
                        }});
                }
                else
                {
                    res.status(401).send("Permission Denied");
                }
            }
        });
    }
});


module.exports = router;